#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Torus Knot in R4Mod01.fsh  by mla 
//https://www.shadertoy.com/view/tsBGzt
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

////////////////////////////////////////////////////////////////////////////////
//
// Shows a p,q torus knot, represented as an complex isosurface of the (complex)
// function f(z,w) = z^p - w^q, intersected with the R4 hypersphere, then
// stereographically projected into R3.

// <mouse>: change view
// <up/down>: zoom in/out
// <page up/page down>: change axis of rotation
// 'a': show/hide coordinate axes
// 'g': show R4 coordinate grid
// 'v': vary the length parameter of the distance function
//
// Uncomment #define of DEBUG to see distance field.
//
// Modification by Matthew Arcus of tdhooper's https://www.shadertoy.com/view/wsfGDS
//
////////////////////////////////////////////////////////////////////////////////

//#define DEBUG

const float ITER = 200.0;
const float MAX_DIST = 100.0;
const float FOG_START = 50.0;

// Wind P and Q times round the torus.
// Have gcd(P,Q) components, so just 1 if P,Q
// coprime. 2,3 is basic trefoil knot, 3,3 is
// 3 linked toruses.

//const int P = 2, Q = 3; float tradius = 0.7;
//const int P = 5, Q = 3; float tradius = 0.5;
const int P = 5, Q = 3; float tradius = 0.4;

bool alert = false;

void assert(bool t) {
  if (!t) alert = true;
}

bool eq(float x, float y) {
  return abs(x-y) < 1e-4;
}

#define PI 3.14159265359

const int CHAR_0 = 48;
const int CHAR_A = 65;
const int CHAR_C = 67;
const int CHAR_G = 71;
const int CHAR_T = 84;
const int CHAR_V = 86;
const int KEY_PAGE_UP = 33;
const int KEY_PAGE_DOWN = 34;
const int KEY_LEFT = 37;
const int KEY_UP = 38;
const int KEY_RIGHT = 39;
const int KEY_DOWN = 40;

bool keypress(int code) {
  return texelFetch(iChannel0, ivec2(code,2),0).x != 0.0;
}

vec4 store(int i,int j) {
  return texelFetch(iChannel1, ivec2(i,j),0);
}
int keycount(int key) {
  return int(store(0,key).x);
}

vec2 rotate(vec2 p, float t) {
  return p * cos(t) + vec2(p.y, -p.x) * sin(t);
}

float smax(float a, float b, float r) {
  vec2 u = max(vec2(r + a,r + b), vec2(0));
  return min(-r, max (a, b)) + length(u);
}

vec2 cexp(vec2 z) {
  // If cos and sin were perfect we wouldn't need normalize
  return exp(z.x)*normalize(vec2(cos(z.y),sin(z.y)));
}

vec2 cmul(vec2 z, vec2 w) {
  return vec2(z.x*w.x-z.y*w.y, z.x*w.y+z.y*w.x);
}

vec2 cpow(vec2 z, int n) {
  vec2 z0 = z;
  for (int i = 1; i < n; i++) z = cmul(z,z0);
  return z;
}

vec2 clog(vec2 z) {
  float r2 = dot(z,z);
  return vec2(0.5*log(r2),atan(z.y,z.x));
}

vec2 cpow(vec2 w, vec2 z) {
  return cexp(cmul(z,clog(w)));
}

vec2 cpow(vec2 z, float x) {
  float r = dot(z,z);
  float theta = atan(z.y,z.x);
  return pow(r,0.5*x)*normalize(vec2(cos(x*theta),sin(x*theta)));
}

// --------------------------------------------------------
// Main SDF
// --------------------------------------------------------

// Stereographic projection of p, by inversion.
// k is scale factor
vec4 stereographic(vec4 p, out float k) {
  p.w += 1.0;
  k = 2.0/dot(p,p);
  p *= k;
  p.w -= 1.0;
  return p;
}


float eval(vec4 p) {
  // "Distance" from z^p - w^q = 0, so intersected with z²+w² = 1 (hypersphere)
  
  vec2 z0 = p.xy, w0 = p.zw;
  vec2 z = cpow(z0,P), w = cpow(w0,Q);
  //w -= w0;
  //z -= z0; // for more fun
  return length(z-w);
}

float fTorus(vec4 p, float k) {
  float fp = eval(p);
#if 1
  float eps = 1e-3;
  vec2 e = vec2(eps,0);
  // Numeric gradient.
  // Should be able to do this analytically
  vec4 grad = vec4(eval(p+e.xyyy)-fp,  
                   eval(p+e.yxyy)-fp,
                   eval(p+e.yyxy)-fp,
                   eval(p+e.yyyx)-fp)/eps;
#else
  vec4 grad = vec4(float(P)*cpow(p.xy,P-1),
                   float(Q)*cpow(p.zw,Q-1));
#endif
  // Use abs here 
  return abs(fp-k)/length(grad);

#if 0
  // Torus distance
  // Distance from surface x^2 + y^2 = 0.5
  float d = k-length(p.xy);
  //float d = length(p.zw)-k;
  return d;
#endif
}

bool hitDebugTorus = false;
bool hitDebugPlane = false;

vec4 qmul(vec4 p, vec4 q) {
  return vec4(cross(p.xyz,q.xyz)+p.w*q.xyz+q.w*p.xyz,
              p.w*q.w-dot(p.xyz,q.xyz));
}

vec4 quat;

bool docentre = false;
bvec4 doelement = bvec4(true);

float torus(vec4 p4, vec3 p, float k) {
  return fTorus(p4,k);
}

int type = -1;

float map(vec3 p) {
  float k;
  vec4 p4 = stereographic(vec4(p,0),k);

  // Do a one sided quaternion rotation, otherwise known
  // as a Clifford Translation, which seems appropriate.
  p4 = qmul(p4,quat);

  float d = 1e8;
  type = -1;
  if (doelement[0]) {
    float d0 = d;
    d = min(d,torus(p4.xyzw,p,tradius));
    if (d < d0) type = 0;
  }
  if (doelement[1]) {
    float d0 = d;
    d = min(d,torus(p4.xzyw,p,tradius));
    if (d < d0) type = 1;
  }
  if (doelement[2]) {
    float d0 = d;
    d = min(d,torus(p4.xwyz,p,tradius));
    if (d < d0) type = 2;
  }
  if (doelement[3]) {
    float lwidth = 0.02;
    float d0 = d;
    d = min(d,length(p4.xy)-lwidth);
    d = min(d,length(p4.xz)-lwidth);
    d = min(d,length(p4.xw)-lwidth);
    d = min(d,length(p4.yz)-lwidth);
    d = min(d,length(p4.yw)-lwidth);
    d = min(d,length(p4.zw)-lwidth);
    if (d < d0) type = 3;
  }
  return d/k;
}

float mapDebug(vec3 p) {
  float d = map(p);
#ifndef DEBUG
  return d;
#endif
  float plane = min(abs(p.z), abs(p.y));
  hitDebugPlane = plane < abs(d);
  return hitDebugPlane ? plane : d;
}


// --------------------------------------------------------
// Rendering
// --------------------------------------------------------

vec3 calcNormal(vec3 p, float raylength) {
  vec3 eps = vec3(.0001*raylength,0,0);
  vec3 n = vec3(
                map(p + eps.xyy) - map(p - eps.xyy),
                map(p + eps.yxy) - map(p - eps.yxy),
                map(p + eps.yyx) - map(p - eps.yyx)
                );
  return normalize(n);
}

mat3 calcLookAtMatrix(vec3 ro, vec3 ta, vec3 up) {
  vec3 ww = normalize(ta - ro);
  vec3 uu = normalize(cross(ww,up));
  vec3 vv = normalize(cross(uu,ww));
  return mat3(uu, vv, ww);
}

vec3 transform(in vec3 p) {
  if (iMouse.x > 0.0) {
    float theta = (2.0*iMouse.y-iResolution.y)/iResolution.y*PI;
    float phi = (2.0*iMouse.x-iResolution.x)/iResolution.x*PI;
    p.yz = rotate(p.yz,theta);
    p.zx = rotate(p.zx,-phi);
  }
  return p;
}

vec3 hsv2rgb(float h, float s, float v) {
  vec3 rgb = clamp( abs(mod(h*6.0+vec3(0.0,4.0,2.0),6.0)-3.0)-1.0, 0.0, 1.0 );
  rgb = rgb*rgb*(3.0-2.0*rgb); // cubic smoothing       
  return v * mix( vec3(1.0), rgb, s);
}

vec3 axes[] = vec3[] (vec3(1,0,0),  
                      vec3(0,1,0),
                      vec3(0,0,1),
                      vec3(1,1,0),
                      vec3(1,0,1),
                      vec3(0,1,1),
                      vec3(1,1,1));

vec3 getcolor(int type) {
  vec3 color = vec3(0);
  if (type == 3) color = vec3(1,0,0);
  else color = hsv2rgb(float(type)/3.0 + 0.0*iTime,0.2,0.8);
  return color;
}

vec3 gridcolor(int type) {
  return hsv2rgb(float(type)/4.0 ,0.6,0.4);
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
  docentre = false;
  doelement[0] = true;
  doelement[1] = false;
  doelement[2] = false;
  doelement[3] = !keypress(CHAR_A);
  
  vec3 light = normalize(vec3(1,.5,0));
  vec3 camPos = vec3(1.8, 5.5, -5.5);
  vec3 camTar = vec3(.1,0,.1);
  vec3 camUp = vec3(-1,0,-1.5);

  mat3 camMat = calcLookAtMatrix(camPos, camTar, camUp);
  
  float focalLength = 2.5;
  vec3 p = vec3(2.0*(-iResolution.xy + 2. * fragCoord.xy) / iResolution.y, focalLength);
  p = transform(p);
  vec3 rayDirection = normalize(camMat * p);

  float camera = 4.0;
  camera *= 0.1*float(10+keycount(KEY_DOWN)-keycount(KEY_UP));
  vec3 rayOrigin = vec3(0,0,-camera);
  rayOrigin = transform(rayOrigin);
  rayOrigin = camMat * rayOrigin;

  light = transform(light);
  light = camMat * light;
  
  vec3 rayPosition = rayOrigin;
  float rayLength = 0.0;

  float distance = 0.0;
  vec3 color = vec3(0);
  int aindex = keycount(KEY_PAGE_UP)-keycount(KEY_PAGE_DOWN);

  aindex %= axes.length();
  if (aindex < 0) aindex += axes.length();
  vec3 axis = normalize(axes[aindex]);
  float t = iTime;
  quat = normalize(vec4(-sin(0.1*PI*t)*axis,cos(0.1*PI*t)));

  if (keypress(CHAR_V)) tradius = 0.5+0.5*sin(0.2*iTime);
  
  for (float i = 0.; i < ITER; i++) {
    if (distance > 1.0) distance *= 0.5;
    else distance *= 0.8;
    rayLength += distance;
    rayPosition = rayOrigin + rayDirection * rayLength;
    distance = mapDebug(rayPosition);

    if (distance/rayLength < .001) break;
    if (rayLength > MAX_DIST) break;
  }
  float k;

  vec3 normal = calcNormal(rayPosition,rayLength);
  map(rayPosition); // get type
  color = getcolor(type);
  if (type != 3 && !keypress(CHAR_G)) {
    vec4 p4 = stereographic(vec4(rayPosition,0),k);
    p4 = qmul(p4,quat);
    p4 *= 8.0;
    p4 = mod(p4,2.0);
    p4 = min(p4,2.0-p4);
    float d = p4.x;
    int type = 0;
    if (p4.y < d) { d = p4.y; type = 1; }
    if (p4.z < d) { d = p4.z; type = 2; }
    if (p4.w < d) { d = p4.w; type = 3; }
    //float edge = min(min(p4.x,p4.y),min(p4.z,p4.w));
    color = mix(gridcolor(type),color,smoothstep(0.1,0.125,d));;
  }
  color *= clamp(dot(light, normal),0.0,1.0) * .8 + .2;
  color += pow(clamp(dot(rayDirection,reflect(light,normal)),0.0,1.0),10.0);

#if defined DEBUG
  if (hitDebugPlane) {
    float l = PI*length(rayPosition);
    float d = PI*map(rayPosition);
    color = 0.25*vec3(0,1.0+sin(20.0*d),1.0+sin(20.0*l));
  }
#else
  float fog = pow(smoothstep(FOG_START, MAX_DIST, rayLength), 1.0);
  color = mix(color, vec3(0), fog);
  color *= mix(1., .025, fog);
#endif

  color = pow(color, vec3(1. / 2.2)); // Gamma
  if (alert) color.x = 1.0;
  fragColor = vec4(color, 1);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

